<?php

namespace Minimog\Woo;

defined( 'ABSPATH' ) || exit;

class Checkout {

	protected static $instance = null;

	public static function instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	public function initialize() {
		// Remove original then use modal.
		remove_action( 'woocommerce_before_checkout_form', 'woocommerce_checkout_coupon_form', 10 );

		// Remove Duplicate.
		remove_action( 'woocommerce_before_checkout_form', 'woocommerce_output_all_notices', 10 );

		// Add heading before payment block.
		add_action( 'woocommerce_review_order_before_payment', [ $this, 'template_checkout_payment_title', ], 10 );

		add_filter( 'woocommerce_checkout_fields', [ $this, 'override_checkout_fields' ] );

		add_filter( 'woocommerce_gateway_icon', [ $this, 'new_gateway_icon' ], 99, 2 );

		// Checkout Received.
		remove_action( 'woocommerce_thankyou', 'woocommerce_order_details_table', 10 );
		add_action( 'minimog/woocommerce/after_thankyou', 'woocommerce_order_details_table', 10 );

		/* Error message next to the field */
		add_filter( 'woocommerce_form_field', [ $this, 'show_form_error_message' ], 10, 4 );
		/* Combined all required error messages to only one. */
		add_action( 'woocommerce_after_checkout_validation', [ $this, 'update_error_messages' ], 10, 2 );

		add_action( 'wp_footer', [ $this, 'output_modals' ] );
	}

	public function template_checkout_payment_title() {
		?>
		<h3 class="checkout-payment-info-heading"><?php esc_html_e( 'Payment information', 'minimog' ); ?></h3>
		<?php
	}

	/**
	 * Add placeholder for all fields.
	 *
	 * @param $fields
	 *
	 * @return mixed
	 */
	public function override_checkout_fields( $fields ) {
		// Add placeholder for billing form.
		foreach ( $fields['billing'] as $field => $value ) {
			/**
			 * Add custom class for some fields
			 * Don't apply custom class for these fields it caused layout overlap on different countries:
			 * case billing_city, billing_state, billing_postcode, shipping_city, shipping_state, shipping_postcode
			 */
			switch ( $field ) {
				case 'billing_first_name':
				case 'billing_last_name':
				case 'billing_phone':
				case 'billing_email':
					$fields['billing'][ $field ]['class'][] = 'col-sm-6';
					break;
				default :
					$fields['billing'][ $field ]['class'][] = 'col-sm-12';
					break;
			}
		}

		// Add placeholder for shipping form.
		foreach ( $fields['shipping'] as $field => $value ) {
			/**
			 * Add custom class for some fields
			 */
			switch ( $field ) {
				case 'shipping_first_name':
				case 'shipping_last_name':
				case 'shipping_phone':
				case 'shipping_email':
					$fields['shipping'][ $field ]['class'][] = 'col-sm-6';
					break;
				default :
					$fields['shipping'][ $field ]['class'][] = 'col-sm-12';
					break;
			}
		}

		return $fields;
	}

	/**
	 * @param string $icon Old html icon string of the payment gateway.
	 * @param string $id   Id of the payment gateway.
	 *                     Set default $id = null to fix poor params in 3rd plugins.
	 *
	 * @return mixed
	 */
	public function new_gateway_icon( $icon, $id = null ) {
		switch ( $id ) {
			// Direct bank transfer - pay.svg.
			case 'bacs':
				$icon = '<svg version="1.1" viewBox="0 0 512.16 512.16" xmlns="http://www.w3.org/2000/svg"><path d="m272.07 336.15h136.53c5.12 0 8.533-3.413 8.533-8.533v-76.8c0-5.12-3.413-8.533-8.533-8.533h-136.53c-5.12 0-8.533 3.413-8.533 8.533v76.8c-1e-3 5.119 3.413 8.533 8.533 8.533zm8.533-76.8h119.47v59.733h-119.47v-59.733z"/><path d="m41.667 225.21h68.267c5.12 0 8.533-3.413 8.533-8.533s-3.413-8.533-8.533-8.533h-68.267c-5.12 0-8.533 3.413-8.533 8.533s3.413 8.533 8.533 8.533z"/><path d="m144.07 225.21h68.267c5.12 0 8.533-3.413 8.533-8.533s-3.413-8.533-8.533-8.533h-68.267c-5.12 0-8.533 3.413-8.533 8.533s3.413 8.533 8.533 8.533z"/><path d="m41.667 259.35h110.93c5.12 0 8.533-3.413 8.533-8.533s-3.413-8.533-8.533-8.533h-110.93c-5.12 0-8.533 3.413-8.533 8.533s3.413 8.533 8.533 8.533z"/><path d="m212.33 242.28h-25.6c-5.12 0-8.533 3.413-8.533 8.533s3.413 8.533 8.533 8.533h25.6c5.12 0 8.533-3.413 8.533-8.533s-3.413-8.533-8.533-8.533z"/><path d="m503.32 136.47c-5.973-7.68-13.653-11.947-23.04-12.8l-20.48-2.482v-41.038c0-18.773-15.36-34.133-34.133-34.133h-392.53c-18.773-1e-3 -34.133 15.359-34.133 34.133v273.07c0 15.413 10.357 28.518 24.453 32.718-0.43 17.262 12.631 32.248 30.161 33.842l394.24 44.373h3.413c17.067 0 32.427-12.8 34.133-29.013l25.6-273.92c0.853-8.534-1.707-17.921-7.68-24.747zm-487.25-30.72h426.67v51.2h-426.67v-51.2zm17.066-42.667h392.53c9.387 0 17.067 7.68 17.067 17.067v8.533h-426.67v-8.533c0-9.387 7.68-17.067 17.066-17.067zm-17.066 290.13v-179.2h426.67v179.2c0 9.387-7.68 17.067-17.067 17.067h-392.53c-9.387 0-17.067-7.68-17.067-17.067zm477.87-195.41-25.6 273.92c-0.853 9.387-9.387 16.213-18.773 15.36l-393.39-44.373c-8.533-0.853-14.507-7.68-15.36-15.36h384.85c18.773 0 34.133-15.36 34.133-34.133v-215.89l19.627 1.707c4.267 0 8.533 2.56 11.093 5.973 2.561 3.413 4.268 8.533 3.414 12.8z"/></svg>';
				break;

			// Check Payments - check-payments.svg.
			case 'cheque':
				$icon = '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" viewBox="0 0 512 512"><path d="M313.583,134.372H87.111c-4.808,0-8.711,3.896-8.711,8.711c0,4.808,3.896,8.711,8.711,8.711h226.472c4.808,0,8.711-3.902,8.711-8.711C322.294,138.268,318.391,134.372,313.583,134.372z"/><path d="M272.935,192.442H87.111c-4.808,0-8.711,3.896-8.711,8.711c0,4.808,3.896,8.711,8.711,8.711h185.824c4.808,0,8.711-3.903,8.711-8.711C281.645,196.338,277.743,192.442,272.935,192.442z"/><path d="M180.022,250.511H87.111c-4.808,0-8.711,3.896-8.711,8.711c0,4.808,3.902,8.711,8.711,8.711h92.911c4.808,0,8.711-3.903,8.711-8.711C188.733,254.409,184.83,250.511,180.022,250.511z"/><path d="M508.611,163.831l-35.771-35.765c-0.749-0.749-1.591-1.324-2.474-1.823V79.206c0-12.775-10.452-23.228-23.228-23.228H23.228C10.452,55.978,0,66.43,0,79.206v278.735c0,12.775,10.452,23.228,23.228,23.228h182.078c-2.282,3.624-4.251,7.497-5.308,10.662l-18.751,56.252c-1.62,4.854,0.174,7.939,4.07,7.939c0.964,0,2.062-0.192,3.269-0.593l56.252-18.751c6.057-2.021,14.715-7.369,19.233-11.881l43.634-43.627h139.437c12.775,0,23.228-10.452,23.228-23.228V218.498l38.244-38.245C513.129,175.741,513.129,168.349,508.611,163.831z M23.233,363.748c-3.147,0-5.807-2.66-5.807-5.807V79.206c0-3.147,2.66-5.807,5.807-5.807h423.91c3.147,0,5.807,2.66,5.807,5.807v52.333l-13.472,13.472l-7.445-7.45c-3.96-3.96-9.209-5.947-14.372-5.935c-5.168-0.006-10.418,1.98-14.378,5.947l-70.073,70.067c-3.403,3.403-3.403,8.919,0,12.317c3.403,3.403,8.914,3.403,12.317,0l70.079-70.079c0.557-0.557,1.26-0.831,2.056-0.836c0.79,0.006,1.492,0.279,2.056,0.836l7.445,7.445L220.735,363.748H23.233z M239.335,420.146l-34.209,11.405l11.4-34.221c0.715-2.137,2.416-5.273,4.233-7.996l26.572,26.572C244.59,417.73,241.437,419.449,239.335,420.146z M260.142,404.09l-27.554-27.56L413.377,195.74l27.56,27.554L260.142,404.09z M452.952,357.941L452.952,357.941c0,3.147-2.66,5.807-5.807,5.807H325.128l127.824-127.829V357.941z M453.253,210.977l-27.56-27.554l38.936-38.936l27.56,27.554L453.253,210.977z"/></svg>';
				break;

			// Cash on delivery.
			case 'cod':
				$icon = '<svg viewBox="0 0 511 511.99978" xmlns="http://www.w3.org/2000/svg"><path d="m235.792969 347.265625c3.902343-3.910156 3.902343-10.238281 0-14.148437-3.90625-3.898438-10.234375-3.898438-14.144531 0-3.898438 3.910156-3.898438 10.238281 0 14.148437 3.910156 3.898437 10.238281 3.898437 14.144531 0zm0 0"/><path d="m188.449219 109.96875c0 60.636719 49.332031 109.972656 109.96875 109.972656s109.96875-49.335937 109.96875-109.972656-49.332031-109.96875-109.96875-109.96875-109.96875 49.332031-109.96875 109.96875zm199.945312 0c0 49.613281-40.363281 89.976562-89.976562 89.976562s-89.976563-40.363281-89.976563-89.976562c0-49.609375 40.363282-89.972656 89.976563-89.972656s89.976562 40.363281 89.976562 89.972656zm0 0"/><path d="m115.652344 509.042969c3.875 3.90625 10.183594 3.949219 14.109375.082031l48.46875-47.75c8.234375-8.234375 10.738281-20.425781 7.117187-31.023438l10.425782-10.054687c5.613281-5.421875 13.003906-8.410156 20.816406-8.410156h132.902344c23.578124 0 45.863281-9.054688 62.757812-25.496094.695312-.675781-5.277344 6.359375 90.667969-108.3125 14.230469-16.835937 12.101562-42.117187-4.75-56.363281-16.746094-14.113282-41.832031-12.085938-56.101563 4.460937l-58.992187 60.632813c-7.449219-9.167969-18.808594-14.882813-31.082031-14.882813h-111.480469c-15.863281-6.636719-32.695313-9.996093-50.0625-9.996093-48.140625 0-90.175781 22.234374-112.734375 63.921874-9.503906-1.800781-19.527344 1.074219-26.738282 8.285157l-47.558593 47.699219c-3.882813 3.894531-3.890625 10.195312-.015625 14.101562zm74.792968-227.121094c15.3125 0 30.117188 3.082031 44.011719 9.160156 1.265625.554688 2.628907.839844 4.007813.839844h113.527344c10.839843 0 19.996093 8.839844 19.996093 19.992187 0 11.027344-8.96875 19.996094-19.996093 19.996094h-81.566407c-5.519531 0-9.996093 4.476563-9.996093 9.996094 0 5.523438 4.476562 9.996094 9.996093 9.996094h81.566407c22.050781 0 39.988281-17.9375 39.988281-39.988282 0-1.757812-.125-3.5-.351563-5.226562 57.066406-58.660156 65.113282-66.902344 65.457032-67.3125 7.125-8.410156 19.773437-9.476562 28.1875-2.382812 8.421874 7.121093 9.488281 19.761718 2.34375 28.21875l-89.667969 107.195312c-13.09375 12.570312-30.285157 19.488281-48.457031 19.488281h-132.902344c-13.023438 0-25.351563 4.980469-34.703125 14.015625l-8.496094 8.199219-78.320313-78.316406c18.304688-34.339844 52.652344-53.871094 95.375-53.871094zm-125.320312 66.34375c3.296875-3.296875 8.359375-3.890625 12.378906-1.40625 1.730469 1.054687-3.238281-3.46875 86.589844 86.234375 3.996094 3.996094 3.78125 10.363281.054688 14.089844l-41.320313 40.707031-98.230469-98.980469zm0 0"/><path d="m286.421875 49.988281v11.714844c-11.636719 4.125-19.996094 15.238281-19.996094 28.273437 0 16.535157 13.453125 29.992188 29.992188 29.992188 5.511719 0 9.996093 4.484375 9.996093 9.996094 0 5.511718-4.484374 9.996094-9.996093 9.996094-4.269531 0-8.882813-2.683594-12.980469-7.5625-3.554688-4.226563-9.859375-4.769532-14.085938-1.21875-4.226562 3.554687-4.773437 9.859374-1.21875 14.085937 5.34375 6.355469 11.628907 10.785156 18.289063 13.019531v11.667969c0 5.523437 4.476563 9.996094 9.996094 9.996094s9.996093-4.472657 9.996093-9.996094v-11.714844c11.636719-4.128906 19.996094-15.242187 19.996094-28.273437 0-16.539063-13.453125-29.992188-29.992187-29.992188-5.511719 0-9.996094-4.484375-9.996094-9.996094 0-5.511718 4.484375-10 9.996094-10 3.542969 0 7.28125 1.808594 10.8125 5.226563 3.96875 3.839844 10.296875 3.734375 14.136719-.230469 3.839843-3.96875 3.734374-10.296875-.230469-14.136718-5.074219-4.910157-10.152344-7.6875-14.722657-9.203126v-11.644531c0-5.523437-4.476562-10-9.996093-10s-9.996094 4.476563-9.996094 10zm0 0"/></svg>';
				break;

			// PayPal.
			case 'paypal':
			case 'ppcp-gateway':
				$icon = '<svg version="1.1" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg"><path d="m476.17 169.72c-9.687-35.524-34.838-60.946-72.909-73.865-4.511-26.425-16.475-47.896-35.655-63.87-25.471-21.212-63.248-31.968-112.28-31.968h-111.5c-11.167-0.467-33.305 6.234-39.179 34.907l-73.005 356.94c-0.043 0.208-0.078 0.417-0.108 0.628-0.22 1.572-1.905 15.638 6.632 25.457 3.382 3.889 9.651 8.525 20.308 8.525h49.602c0.357 0.017 0.727 0.024 1.111 0.024 2.435 0 5.391-0.348 8.561-1.207l-10.647 52.058c-0.043 0.208-0.079 0.417-0.108 0.628-0.22 1.572-1.905 15.639 6.632 25.457 3.382 3.889 9.651 8.525 20.308 8.525h49.593c0.407 0.02 0.828 0.03 1.261 0.03 11.544 0 31.991-7.274 36.556-35.689l16.482-81.478c0.281-1.218 3.833-15.274 17.331-15.274 0.861 0 1.927 0.011 3.181 0.022 16.557 0.162 60.545 0.605 105.73-14.622 25.951-8.744 48.038-21.327 65.645-37.4 21.542-19.664 36.531-44.676 44.549-74.336 4.587-16.961 10.937-50.365 1.902-83.497zm-97.051-7.312c-19.699 72.878-85.909 111.31-191.62 111.31-1.459 0-2.938-8e-3 -4.412-0.022-1.335-0.013-2.469-0.023-3.384-0.023-3.792 0-7.254 0.513-10.41 1.418l30.8-150.59c3.589-17.517 15.475-18.609 18.368-18.609 0.042 0 0.083 1e-3 0.121 1e-3 0.217 0.017 0.208 9e-3 0.474 9e-3h111.73c20.137 0 38.203 1.935 53.825 5.754 1.366 21.206-2.73 40.555-5.489 50.751zm-270.19 243.69c-0.263-0.023-0.269-0.014-0.577-0.014h-49.874c-3.58 0-4.57-1.121-4.896-1.489-1.735-1.961-2.128-6.501-1.869-9.045l72.921-356.53c3.589-17.517 15.475-18.609 18.368-18.609 0.042 0 0.083 1e-3 0.121 1e-3 0.217 0.017 0.208 9e-3 0.474 9e-3h111.73c71.327 0 113.57 23.397 125.84 69.599-15.164-2.996-32.04-4.511-50.383-4.511h-111.5c-11.158-0.47-33.305 6.234-39.179 34.907l-55.935 273.48c-4.163 11.689-13.207 12.27-15.243 12.201zm345.65-158.2c-19.699 72.878-85.909 111.31-191.62 111.31-1.459 0-2.938-8e-3 -4.412-0.022-1.335-0.013-2.469-0.023-3.384-0.023-24.018 0-34.878 20.505-37.266 31.348-0.013 0.057-0.024 0.113-0.037 0.171l-16.547 81.797c-0.029 0.147-0.056 0.293-0.078 0.441-2.808 17.886-14.247 18.699-16.838 18.668-0.264-0.023-0.271-0.014-0.582-0.014h-49.874c-3.58 0-4.57-1.121-4.896-1.489-1.735-1.961-2.128-6.501-1.869-9.045l35.187-171.64c0.476-1.937 4.244-15.329 17.344-15.329 0.861 0 1.927 0.011 3.181 0.022 16.558 0.163 60.545 0.605 105.73-14.622 25.951-8.744 48.038-21.327 65.645-37.4 21.542-19.664 36.531-44.676 44.549-74.336 2.752-10.174 6.683-28.476 6.453-49.345 68.014 28.641 57.525 99.151 49.313 129.5z"/><path d="m111.82 210.26c-5.517-1.126-10.905 2.434-12.032 7.953l-0.97 4.753c-1.126 5.518 2.434 10.905 7.953 12.032 0.688 0.141 1.375 0.208 2.051 0.208 4.745 0 8.995-3.331 9.981-8.161l0.97-4.753c1.126-5.518-2.435-10.905-7.953-12.032z"/><path d="m104.06 248.28c-5.517-1.126-10.905 2.434-12.032 7.953l-25.799 126.4c-1.126 5.518 2.434 10.905 7.953 12.032 0.688 0.141 1.375 0.208 2.051 0.208 4.745 0 8.995-3.331 9.981-8.161l25.798-126.4c1.126-5.519-2.434-10.906-7.952-12.032z"/></svg>';
				break;

			// Credit Card (Stripe).
			case 'stripe':
				$icon = '<svg version="1.1" viewBox="0 0 478.98 478.98" xmlns="http://www.w3.org/2000/svg"><rect x="344" y="319.49" width="48" height="16"/><rect x="280" y="319.49" width="48" height="16"/><rect x="216" y="319.49" width="48" height="16"/><path d="m471.9 165.92-158.3-158.32c-4.495-4.538-10.62-7.088-17.008-7.08h-0.072c-6.346 3e-3 -12.424 2.554-16.872 7.08l-167.92 167.9h-87.728c-13.255 0-24 10.745-24 24v224c0 13.255 10.745 24 24 24h118.53l23.872 23.896c4.495 4.538 10.62 7.088 17.008 7.08h0.064c6.348-2e-3 12.43-2.553 16.88-7.08l23.92-23.896h183.73c13.255 0 24-10.745 24-24v-183.73l39.856-39.856c4.549-4.453 7.117-10.547 7.128-16.912 0.024-6.414-2.53-12.568-7.088-17.08zm-101.77-79.144-88.72 88.72h-67.936l122.69-122.69 33.968 33.968zm-79.152-67.896c3.043-3.117 8.037-3.177 11.155-0.133 0.045 0.044 0.09 0.088 0.133 0.133l22.584 22.616-134.01 134h-56.488l156.62-156.62zm-101.95 441.23c-1.463 1.528-3.485 2.394-5.6 2.4-2.144-5e-3 -4.196-0.869-5.696-2.4l-12.568-12.616h36.488l-12.624 12.616zm226.98-36.616c0 4.418-3.582 8-8 8h-384c-4.418 0-8-3.582-8-8v-112h400v112zm0-128h-400v-48h400v48zm0-64h-400v-32c0-4.418 3.582-8 8-8h384c4.418 0 8 3.582 8 8v32zm44.584-42.936-28.584 28.584v-17.648c0-13.255-10.745-24-24-24h-104l77.408-77.408 79.144 79.144c1.537 1.506 2.402 3.568 2.4 5.72-2e-3 2.112-0.856 4.134-2.368 5.608z"/><path d="m76.728 415.71c1.168-1.01 2.262-2.104 3.272-3.272 10.579 12.322 28.756 14.663 42.112 5.424 8.62-6.027 13.794-15.85 13.888-26.368 0-17.673-14.327-32-32-32-1.588-0.022-3.174 0.112-4.736 0.4l-0.208 0.056h-0.232c-7.329 1.218-13.994 4.979-18.824 10.624-11.56-13.368-31.769-14.833-45.136-3.272-13.368 11.56-14.833 31.769-3.272 45.136 11.56 13.368 31.768 14.833 45.136 3.272zm25.248-40.048c0.667-0.127 1.345-0.183 2.024-0.168 8.837 0 16 7.163 16 16-8e-3 3.385-1.111 6.677-3.144 9.384-0.288 0.392-0.512 0.8-0.84 1.208-0.056 0.064-0.136 0.104-0.2 0.168-3.022 3.337-7.314 5.241-11.816 5.24-8.835-0.151-15.876-7.435-15.725-16.27 0.134-7.845 5.936-14.436 13.701-15.562zm-45.976-0.168c8.837 0 16 7.163 16 16s-7.163 16-16 16-16-7.163-16-16 7.163-16 16-16z"/></svg>';
				break;

			// Bitcoin.
			case 'triplea_payment_gateway':
				$icon = '<svg enable-background="new 0 0 512 512" height="512" viewBox="0 0 512 512" width="512" xmlns="http://www.w3.org/2000/svg"><g><path d="m509.417 328.901c-22.94-25.365-60.746-30.827-89.958-12.945l-54.593 33.999c-9.362-28.598-35.985-48.715-66.667-49.123l-55.501-1.129c-31.414-18.437-71.773-11.263-94.98 17.292-5.98 7.358-10.887 14.307-14.644 20.732h-14.238v-7.53c0-5.523-4.478-10-10-10h-98.836c-5.522 0-10 4.477-10 10v118.122c0 5.523 4.478 10 10 10h98.836c5.522 0 10-4.477 10-10v-12.799l137.289 30.143c9.323 2.09 18.796 3.117 28.224 3.117 23.791-.001 47.269-6.548 67.147-19.091.771-.487 85.322-57.805 156.115-105.803 2.396-1.625 3.971-4.207 4.316-7.081.347-2.874-.569-5.757-2.51-7.904zm-410.581 109.418h-78.836v-98.122h78.836zm241.892-5.486c-23.301 14.667-52.536 19.521-80.271 13.303l-141.62-31.094v-57.316h20.17c3.777 0 7.232-2.128 8.932-5.502 3.33-6.613 8.478-14.222 15.3-22.616 17.402-21.41 47.994-26.375 71.156-11.542 1.552.993 3.348 1.539 5.189 1.576l58.28 1.185c21.992.292 41.059 14.621 47.891 35.033h-120.952c-5.522 0-10 4.477-10 10s4.478 10 10 10h133.437c1.869 0 3.7-.523 5.286-1.512l66.439-41.376c17.535-10.732 39.433-9.729 55.775 1.577-54.234 36.772-141.613 96.007-145.012 98.284z"/><path d="m68.203 391.044c-5.522 0-10 4.477-10 10v7.347c0 5.523 4.478 10 10 10s10-4.477 10-10v-7.347c0-5.523-4.477-10-10-10z"/><path d="m369.851 302.199c71.401 0 129.49-58.089 129.49-129.489s-58.089-129.489-129.49-129.489c-71.4 0-129.489 58.089-129.489 129.489s58.088 129.489 129.489 129.489zm0-238.978c60.373 0 109.49 49.117 109.49 109.489s-49.117 109.489-109.49 109.489-109.49-49.117-109.49-109.489 49.117-109.489 109.49-109.489z"/><path d="m338.151 220.364h-3.618c-5.522 0-10 4.477-10 10s4.478 10 10 10h3.618v2.986c0 5.523 4.478 10 10 10s10-4.477 10-10v-3.028c2.216-.009 4.658-.019 7.169-.029v3.057c0 5.523 4.478 10 10 10s10-4.477 10-10v-3.12c.648-.001 1.227-.001 1.727-.001 22.433 0 40.683-18.25 40.683-40.684 0-14.22-7.334-26.76-18.418-34.036 5.112-6.247 8.183-14.226 8.183-22.909 0-18.606-14.099-33.98-32.174-36.003v-3.212c0-5.523-4.478-10-10-10s-10 4.477-10 10v2.986h-7.169v-2.986c0-5.523-4.478-10-10-10s-10 4.477-10 10v2.986h-3.618c-5.522 0-10 4.477-10 10s4.478 10 10 10h3.618v93.993zm48.896-.136c-5.245 0-19.201.053-28.896.093v-41.417c3.437-.014 7.352-.03 11.044-.042h17.852c11.404 0 20.683 9.278 20.683 20.683s-9.279 20.683-20.683 20.683zm10.447-77.628c0 8.949-7.281 16.23-16.23 16.23-2.435 0-7.046.013-12.073.031h-11.039v-32.491h23.112c8.949.001 16.23 7.282 16.23 16.23z"/></g></svg>';
				break;
		}

		return $icon;
	}

	public function show_form_error_message( $field, $key, $args, $value ) {
		if ( $args['required'] ) {
			$str_pos = strpos( $field, '</p>' );
			if ( $str_pos !== false ) {
				$error = '<span class="form-error form-error__invalid-required" style="display: none;">' . __( 'This field is required.', 'minimog' ) . '</span>';
				$field = substr_replace( $field, $error, $str_pos, 0 );
			}
		}

		if ( 'tel' === $args['type'] ) {
			$str_pos = strpos( $field, '</p>' );
			if ( $str_pos !== false ) {
				$error = '<span class="form-error form-error__invalid-phone" style="display: none;">' . __( 'Please enter valid phone number.', 'minimog' ) . '</span>';
				$field = substr_replace( $field, $error, $str_pos, 0 );
			}
		}

		if ( 'email' === $args['type'] ) {
			$str_pos = strpos( $field, '</p>' );
			if ( $str_pos !== false ) {
				$error = '<span class="form-error form-error__invalid-email" style="display: none;">' . __( 'Please enter valid email address.', 'minimog' ) . '</span>';
				$field = substr_replace( $field, $error, $str_pos, 0 );
			}
		}

		return $field;
	}

	/**
	 * Combined all required error messages to only one.
	 *
	 * @param           $data
	 * @param \WP_Error $errors
	 */
	public function update_error_messages( $data, $errors ) {
		$error_codes        = $errors->get_error_codes();
		$has_required_error = false;

		foreach ( $error_codes as $key => $error_code ) {
			if ( false !== strpos( $error_code, '_required' ) ) {
				$has_required_error = true;

				$errors->remove( $error_code );
			}
		}

		if ( $has_required_error ) {
			$errors->add( 'some_required_fields', apply_filters( 'minimog/checkout/required_field_notice', __( 'Please fill in all required fields.', 'minimog' ) ) );
		}
	}

	public function output_modals() {
		// Order notes enable + show in checkout.
		if ( apply_filters( 'woocommerce_enable_order_notes_field', 'yes' === get_option( 'woocommerce_enable_order_comments', 'yes' ) ) && '1' === \Minimog::setting( 'checkout_page_modal_customer_notes_enable' ) ) {
			wc_get_template( 'cart/modals/modal-order-notes.php' );
		}

		if ( 'yes' === get_option( 'woocommerce_enable_shipping_calc' ) ) {
			wc_get_template( 'cart/modals/modal-shipping-calculator.php' );
		}

		if ( wc_coupons_enabled() ) {
			wc_get_template( 'cart/modals/modal-coupon.php' );
		}
	}
}

Checkout::instance()->initialize();
