<?php
defined( 'ABSPATH' ) || exit;

class Minimog_SVG_Manager {

	private static $instance = null;

	public static function instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	public function initialize() {
	}

	/**
	 * @param string $name Icon name
	 *
	 * @return string Svg tag
	 */
	public function get( $name ) {
		$icon = '';
		switch ( $name ) :
			// Custom.
			case 'star-full':
				$icon = '<svg xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" viewBox="0 0 512 512" xml:space="preserve" class="tm-star-full"><path fill="#000000" d="M512,197.816L325.961 185.585 255.898 9.569 185.835 185.585 0 197.816 142.534 318.842 95.762 502.431 255.898 401.21 416.035 502.431 369.263 318.842z"></path></svg>';
				break;
			case 'star-empty':
				$icon = '<svg xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" viewBox="0 0 512 512" xml:space="preserve" class="tm-star-empty"><path fill="#000000 " d="M512,197.819l-185.933-12.228L256,9.571l-70.067,176.021L0,197.82l142.658,120.93L95.856,502.429L256,401.214 l160.144,101.215l-46.8-183.671L512,197.819z M256,365.724l-112.464,71.08l32.827-128.831L75.829,222.888l130.971-8.603 L256,90.687l49.2,123.599l131.124,8.602l-100.689,85.077l32.829,128.839L256,365.724z"></path></svg>';
				break;
			case 'star-half':
				$icon = '<svg xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" viewBox="0 0 510 510" xml:space="preserve" class="tm-star-half"><path fill="#000000" d="M510,197.472l-183.37-15.734L255,12.75l-71.629,168.988L0,197.472l0,0l0,0l139.103,120.539L97.41,497.25L255,402.186l0,0l157.59,95.039l-41.692-179.239L510,197.472z M255,354.348V117.172l43.605,102.918l111.689,9.588l-84.711,73.389l25.398,109.166L255,354.348z"></path></svg>';
				break;
			case 'grid-one':
				$icon = '<svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg"><rect x="15.25" y="4.25" width="1.5" height="12.5" rx="0.75" transform="rotate(90 15.25 4.25)" fill="#000000"/><rect x="15.25" y="8.25" width="1.5" height="12.5" rx="0.75" transform="rotate(90 15.25 8.25)" fill="#000000"/><rect x="15.25" y="12.25" width="1.5" height="12.5" rx="0.75" transform="rotate(90 15.25 12.25)" fill="#000000"/></svg>';
				break;
			case 'grid-two':
				$icon = '<svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg"><rect x="6.25" y="2.75" width="1.5" height="12.5" rx="0.75" fill="#000000"/><rect x="10.25" y="2.75" width="1.5" height="12.5" rx="0.75" fill="#000000"/></svg>';
				break;
			case 'grid-three':
				$icon = '<svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg"><rect x="4.25" y="2.75" width="1.5" height="12.5" rx="0.75" fill="#000000"/><rect x="8.25" y="2.75" width="1.5" height="12.5" rx="0.75" fill="#000000"/><rect x="12.25" y="2.75" width="1.5" height="12.5" rx="0.75" fill="#000000"/></svg>';
				break;
			case 'grid-four':
				$icon = '<svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg"><rect x="2.25" y="2.75" width="1.5" height="12.5" rx="0.75" fill="#000000"/><rect x="6.25" y="2.75" width="1.5" height="12.5" rx="0.75" fill="#000000"/><rect x="10.25" y="2.75" width="1.5" height="12.5" rx="0.75" fill="#000000"/><rect x="14.25" y="2.75" width="1.5" height="12.5" rx="0.75" fill="#000000"/></svg>';
				break;
			case 'grid-five':
				$icon = '<svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg"><rect x="0.25" y="2.75" width="1.5" height="12.5" rx="0.75" fill="#000000"/><rect x="4.25" y="2.75" width="1.5" height="12.5" rx="0.75" fill="#000000"/><rect x="8.25" y="2.75" width="1.5" height="12.5" rx="0.75" fill="#000000"/><rect x="12.25" y="2.75" width="1.5" height="12.5" rx="0.75" fill="#000000"/><rect x="16.25" y="2.75" width="1.5" height="12.5" rx="0.75" fill="#000000"/></svg>';
				break;
			case 'bars':
				$icon = '<svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M19.2812 5.84375H2.71875C2.58854 5.84375 2.47135 5.80469 2.36719 5.72656C2.28906 5.6224 2.25 5.50521 2.25 5.375V4.125C2.25 3.99479 2.28906 3.89062 2.36719 3.8125C2.47135 3.70833 2.58854 3.65625 2.71875 3.65625H19.2812C19.4115 3.65625 19.5156 3.70833 19.5938 3.8125C19.6979 3.89062 19.75 3.99479 19.75 4.125V5.375C19.75 5.50521 19.6979 5.6224 19.5938 5.72656C19.5156 5.80469 19.4115 5.84375 19.2812 5.84375ZM19.2812 12.0938H2.71875C2.58854 12.0938 2.47135 12.0547 2.36719 11.9766C2.28906 11.8724 2.25 11.7552 2.25 11.625V10.375C2.25 10.2448 2.28906 10.1406 2.36719 10.0625C2.47135 9.95833 2.58854 9.90625 2.71875 9.90625H19.2812C19.4115 9.90625 19.5156 9.95833 19.5938 10.0625C19.6979 10.1406 19.75 10.2448 19.75 10.375V11.625C19.75 11.7552 19.6979 11.8724 19.5938 11.9766C19.5156 12.0547 19.4115 12.0938 19.2812 12.0938ZM19.2812 18.3438H2.71875C2.58854 18.3438 2.47135 18.3047 2.36719 18.2266C2.28906 18.1224 2.25 18.0052 2.25 17.875V16.625C2.25 16.4948 2.28906 16.3906 2.36719 16.3125C2.47135 16.2083 2.58854 16.1562 2.71875 16.1562H19.2812C19.4115 16.1562 19.5156 16.2083 19.5938 16.3125C19.6979 16.3906 19.75 16.4948 19.75 16.625V17.875C19.75 18.0052 19.6979 18.1224 19.5938 18.2266C19.5156 18.3047 19.4115 18.3438 19.2812 18.3438Z" fill="black"/></svg>';
				break;
			case 'grid':
				$icon = '<svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M1 4.125V17.875C1 18.3958 1.18229 18.8385 1.54688 19.2031C1.91146 19.5677 2.35417 19.75 2.875 19.75H19.125C19.6458 19.75 20.0885 19.5677 20.4531 19.2031C20.8177 18.8385 21 18.3958 21 17.875V4.125C21 3.60417 20.8177 3.16146 20.4531 2.79688C20.0885 2.43229 19.6458 2.25 19.125 2.25H2.875C2.35417 2.25 1.91146 2.43229 1.54688 2.79688C1.18229 3.16146 1 3.60417 1 4.125ZM10.0625 4.125V10.0625H2.875V4.35938C2.875 4.30729 2.90104 4.25521 2.95312 4.20312C3.00521 4.15104 3.05729 4.125 3.10938 4.125H10.0625ZM2.875 11.9375H10.0625V17.875H3.10938C3.05729 17.875 3.00521 17.849 2.95312 17.7969C2.90104 17.7448 2.875 17.6927 2.875 17.6406V11.9375ZM11.9375 17.875V11.9375H19.125V17.6406C19.125 17.6927 19.099 17.7448 19.0469 17.7969C18.9948 17.849 18.9427 17.875 18.8906 17.875H11.9375ZM19.125 10.0625H11.9375V4.125H18.8906C18.9427 4.125 18.9948 4.15104 19.0469 4.20312C19.099 4.25521 19.125 4.30729 19.125 4.35938V10.0625Z" fill="black"/></svg>';
				break;
			case 'home-alt':
				$icon = '<svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M21.779 10.6767L12.369 2.94569C11.9843 2.62539 11.4995 2.45 10.999 2.45C10.4984 2.45 10.0136 2.62539 9.62892 2.94569L0.218899 10.6767C0.157352 10.7282 0.106553 10.7913 0.0694048 10.8625C0.0322563 10.9336 0.00948516 11.0114 0.00239165 11.0913C-0.00470186 11.1712 0.00402122 11.2518 0.0280628 11.3284C0.0521044 11.405 0.0909935 11.476 0.14251 11.5376L0.533623 12.0074C0.637642 12.1316 0.786713 12.2094 0.948074 12.2237C1.10943 12.238 1.26988 12.1877 1.39415 12.0838L2.44336 11.2221V18.3381C2.44426 18.662 2.57333 18.9724 2.80234 19.2014C3.03136 19.4304 3.34171 19.5595 3.66559 19.5604H8.55451C8.87838 19.5595 9.18873 19.4304 9.41775 19.2014C9.64677 18.9724 9.77583 18.662 9.77674 18.3381V14.3659H12.2212V18.3381C12.2221 18.662 12.3512 18.9724 12.5802 19.2014C12.8092 19.4304 13.1195 19.5595 13.4434 19.5604H18.3323C18.6547 19.5597 18.9638 19.4319 19.1926 19.2049C19.4214 18.9778 19.5515 18.6697 19.5546 18.3473V11.2213L20.6061 12.0853C20.7303 12.1892 20.8908 12.2395 21.0521 12.2252C21.2135 12.2109 21.3626 12.1331 21.4666 12.0089L21.8573 11.5395C21.909 11.4778 21.948 11.4065 21.9721 11.3296C21.9961 11.2528 22.0048 11.172 21.9975 11.0918C21.9902 11.0116 21.9672 10.9337 21.9297 10.8624C21.8922 10.7912 21.841 10.7281 21.779 10.6767V10.6767ZM17.7155 17.727H14.0545V13.7548C14.0536 13.4309 13.9246 13.1206 13.6956 12.8915C13.4665 12.6625 13.1562 12.5335 12.8323 12.5326H9.16562C8.84174 12.5335 8.53139 12.6625 8.30238 12.8915C8.07336 13.1206 7.9443 13.4309 7.94339 13.7548V17.727H4.2767V9.71646L10.999 4.19274L17.7212 9.71417L17.7155 17.727Z" fill="black"/></svg>';
				break;
			case 'search':
				$icon = '<svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M20.8438 19.3203C21.0781 19.5286 21.0781 19.75 20.8438 19.9844L19.9844 20.8438C19.75 21.0781 19.5286 21.0781 19.3203 20.8438L14.5938 16.1172C14.4896 16.013 14.4375 15.9089 14.4375 15.8047V15.2578C12.901 16.5859 11.1302 17.25 9.125 17.25C6.88542 17.25 4.97135 16.4557 3.38281 14.8672C1.79427 13.2786 1 11.3646 1 9.125C1 6.88542 1.79427 4.97135 3.38281 3.38281C4.97135 1.79427 6.88542 1 9.125 1C11.3646 1 13.2786 1.79427 14.8672 3.38281C16.4557 4.97135 17.25 6.88542 17.25 9.125C17.25 11.1302 16.5859 12.901 15.2578 14.4375H15.8047C15.9349 14.4375 16.0391 14.4896 16.1172 14.5938L20.8438 19.3203ZM4.71094 13.5391C5.9349 14.763 7.40625 15.375 9.125 15.375C10.8438 15.375 12.3151 14.763 13.5391 13.5391C14.763 12.3151 15.375 10.8438 15.375 9.125C15.375 7.40625 14.763 5.9349 13.5391 4.71094C12.3151 3.48698 10.8438 2.875 9.125 2.875C7.40625 2.875 5.9349 3.48698 4.71094 4.71094C3.48698 5.9349 2.875 7.40625 2.875 9.125C2.875 10.8438 3.48698 12.3151 4.71094 13.5391Z" fill="#000000"/></svg>';
				break;
			case 'shopping-bag':
				$icon = '<svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M15.95 6H19.7V17.875C19.7 18.7344 19.3875 19.4635 18.7625 20.0625C18.1635 20.6875 17.4344 21 16.575 21H5.325C4.46563 21 3.72344 20.6875 3.09844 20.0625C2.49948 19.4635 2.2 18.7344 2.2 17.875V6H5.95C5.95 4.61979 6.43177 3.44792 7.39531 2.48438C8.3849 1.49479 9.56979 1 10.95 1C12.3302 1 13.5021 1.49479 14.4656 2.48438C15.4552 3.44792 15.95 4.61979 15.95 6ZM13.1375 3.8125C12.5385 3.1875 11.8094 2.875 10.95 2.875C10.0906 2.875 9.34844 3.1875 8.72344 3.8125C8.12448 4.41146 7.825 5.14062 7.825 6H14.075C14.075 5.14062 13.7625 4.41146 13.1375 3.8125ZM17.825 17.875V7.875H15.95V9.4375C15.95 9.69792 15.8589 9.91927 15.6766 10.1016C15.4943 10.2839 15.2729 10.375 15.0125 10.375C14.7521 10.375 14.5307 10.2839 14.3484 10.1016C14.1661 9.91927 14.075 9.69792 14.075 9.4375V7.875H7.825V9.4375C7.825 9.69792 7.73385 9.91927 7.55156 10.1016C7.36927 10.2839 7.14792 10.375 6.8875 10.375C6.62708 10.375 6.40573 10.2839 6.22344 10.1016C6.04115 9.91927 5.95 9.69792 5.95 9.4375V7.875H4.075V17.875C4.075 18.2135 4.19219 18.5 4.42656 18.7344C4.68698 18.9948 4.98646 19.125 5.325 19.125H16.575C16.9135 19.125 17.2 18.9948 17.4344 18.7344C17.6948 18.5 17.825 18.2135 17.825 17.875Z" fill="#000000"/></svg>';
				break;
			case 'shopping-basket':
				$icon = '<svg width="23" height="23" viewBox="0 0 23 23" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M22.75 9.9375V10.5625C22.75 10.8229 22.6589 11.0443 22.4766 11.2266C22.2943 11.4089 22.0729 11.5 21.8125 11.5H21.5L20.4844 18.6484C20.4323 18.9349 20.3151 19.1953 20.1328 19.4297C19.9766 19.6901 19.7552 19.8854 19.4688 20.0156C19.2083 20.1719 18.9219 20.25 18.6094 20.25H4.39062C3.92188 20.25 3.50521 20.0938 3.14062 19.7812C2.80208 19.4948 2.59375 19.1172 2.51562 18.6484L1.5 11.5H1.1875C0.927083 11.5 0.705729 11.4089 0.523438 11.2266C0.341146 11.0443 0.25 10.8229 0.25 10.5625V9.9375C0.25 9.67708 0.341146 9.45573 0.523438 9.27344C0.705729 9.09115 0.927083 9 1.1875 9H3.80469L7.98438 3.25781C8.19271 2.97135 8.46615 2.80208 8.80469 2.75C9.14323 2.69792 9.45573 2.77604 9.74219 2.98438C10.0286 3.19271 10.1979 3.46615 10.25 3.80469C10.3021 4.14323 10.224 4.45573 10.0156 4.74219L6.89062 9H16.1094L12.9844 4.74219C12.776 4.45573 12.6979 4.14323 12.75 3.80469C12.8021 3.46615 12.9714 3.19271 13.2578 2.98438C13.5443 2.77604 13.8568 2.69792 14.1953 2.75C14.5339 2.80208 14.8073 2.97135 15.0156 3.25781L19.1953 9H21.8125C22.0729 9 22.2943 9.09115 22.4766 9.27344C22.6589 9.45573 22.75 9.67708 22.75 9.9375ZM12.4375 16.8125V12.4375C12.4375 12.1771 12.3464 11.9557 12.1641 11.7734C11.9818 11.5911 11.7604 11.5 11.5 11.5C11.2396 11.5 11.0182 11.5911 10.8359 11.7734C10.6536 11.9557 10.5625 12.1771 10.5625 12.4375V16.8125C10.5625 17.0729 10.6536 17.2943 10.8359 17.4766C11.0182 17.6589 11.2396 17.75 11.5 17.75C11.7604 17.75 11.9818 17.6589 12.1641 17.4766C12.3464 17.2943 12.4375 17.0729 12.4375 16.8125ZM16.8125 16.8125V12.4375C16.8125 12.1771 16.7214 11.9557 16.5391 11.7734C16.3568 11.5911 16.1354 11.5 15.875 11.5C15.6146 11.5 15.3932 11.5911 15.2109 11.7734C15.0286 11.9557 14.9375 12.1771 14.9375 12.4375V16.8125C14.9375 17.0729 15.0286 17.2943 15.2109 17.4766C15.3932 17.6589 15.6146 17.75 15.875 17.75C16.1354 17.75 16.3568 17.6589 16.5391 17.4766C16.7214 17.2943 16.8125 17.0729 16.8125 16.8125ZM8.0625 16.8125V12.4375C8.0625 12.1771 7.97135 11.9557 7.78906 11.7734C7.60677 11.5911 7.38542 11.5 7.125 11.5C6.86458 11.5 6.64323 11.5911 6.46094 11.7734C6.27865 11.9557 6.1875 12.1771 6.1875 12.4375V16.8125C6.1875 17.0729 6.27865 17.2943 6.46094 17.4766C6.64323 17.6589 6.86458 17.75 7.125 17.75C7.38542 17.75 7.60677 17.6589 7.78906 17.4766C7.97135 17.2943 8.0625 17.0729 8.0625 16.8125Z" fill="#ffffff"/></svg>';
				break;
			case 'star':
				$icon = '<svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M20.425 7.71875C20.9458 7.77083 21.2844 8.04427 21.4406 8.53906C21.5969 9.03385 21.4927 9.46354 21.1281 9.82812L16.9875 13.8516L17.9641 19.5547C18.0422 20.0495 17.8729 20.4401 17.4562 20.7266C17.0396 21.0391 16.6099 21.0781 16.1672 20.8438L11.05 18.1875L5.93281 20.8438C5.4901 21.1042 5.06042 21.0781 4.64375 20.7656C4.22708 20.4531 4.05781 20.0495 4.13594 19.5547L5.1125 13.8516L0.971875 9.82812C0.607292 9.46354 0.503125 9.03385 0.659375 8.53906C0.815625 8.04427 1.15417 7.77083 1.675 7.71875L7.37812 6.85938L9.91719 1.70312C10.1516 1.23438 10.5292 1 11.05 1C11.5708 1 11.9484 1.23438 12.1828 1.70312L14.7219 6.85938L20.425 7.71875ZM14.9953 13.1875L18.9016 9.35938L13.4719 8.57812L11.05 3.65625L8.62812 8.57812L3.19844 9.35938L7.10469 13.1875L6.20625 18.6172L11.05 16.0391L15.8937 18.6172L14.9953 13.1875Z" fill="#000000"/></svg>';
				break;
			case 'heart':
				$icon = '<svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M18.8906 3.4C18.1615 2.775 17.3151 2.38438 16.3516 2.22813C15.388 2.07188 14.4245 2.15 13.4609 2.4625C12.5234 2.775 11.7031 3.28281 11 3.98594C10.2969 3.28281 9.46354 2.775 8.5 2.4625C7.5625 2.15 6.61198 2.07188 5.64844 2.22813C4.6849 2.38438 3.83854 2.775 3.10938 3.4C2.17188 4.20729 1.54688 5.17083 1.23438 6.29063C0.921875 7.30625 0.908854 8.34792 1.19531 9.41563C1.48177 10.4573 1.97656 11.3427 2.67969 12.0719L9.51562 19.025C9.93229 19.4417 10.4271 19.65 11 19.65C11.5729 19.65 12.0677 19.4417 12.4844 19.025L19.3203 12.0719C20.0234 11.3427 20.5182 10.4573 20.8047 9.41563C21.0911 8.34792 21.0911 7.30625 20.8047 6.29063C20.4661 5.17083 19.8281 4.20729 18.8906 3.4ZM17.9922 10.7438L11.1172 17.6969C11.0391 17.801 10.9609 17.801 10.8828 17.6969L4.00781 10.7438C3.53906 10.249 3.20052 9.65 2.99219 8.94688C2.8099 8.21771 2.82292 7.50156 3.03125 6.79844C3.23958 6.04323 3.66927 5.39219 4.32031 4.84531C5.07552 4.22031 5.96094 3.94688 6.97656 4.025C8.01823 4.10313 8.90365 4.51979 9.63281 5.275L11 6.64219L12.3672 5.275C13.0964 4.51979 13.9688 4.10313 14.9844 4.025C16.026 3.94688 16.9245 4.22031 17.6797 4.84531C18.3307 5.39219 18.7604 6.04323 18.9688 6.79844C19.1771 7.50156 19.1771 8.21771 18.9688 8.94688C18.7865 9.65 18.4609 10.249 17.9922 10.7438Z" fill="black"/></svg>';
				break;
			case 'user':
				$icon = '<svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M14.5156 12.875C15.9479 12.875 17.1719 13.3958 18.1875 14.4375C19.2292 15.4531 19.75 16.6771 19.75 18.1094V19.125C19.75 19.6458 19.5677 20.0885 19.2031 20.4531C18.8385 20.8177 18.3958 21 17.875 21H4.125C3.60417 21 3.16146 20.8177 2.79688 20.4531C2.43229 20.0885 2.25 19.6458 2.25 19.125V18.1094C2.25 16.6771 2.75781 15.4531 3.77344 14.4375C4.8151 13.3958 6.05208 12.875 7.48438 12.875C7.82292 12.875 8.31771 12.9792 8.96875 13.1875C9.64583 13.3958 10.3229 13.5 11 13.5C11.6771 13.5 12.3542 13.3958 13.0312 13.1875C13.7083 12.9792 14.2031 12.875 14.5156 12.875ZM17.875 19.125V18.1094C17.875 17.1979 17.5365 16.4167 16.8594 15.7656C16.2083 15.0885 15.4271 14.75 14.5156 14.75C14.4375 14.75 14.0208 14.8542 13.2656 15.0625C12.5365 15.2708 11.7812 15.375 11 15.375C10.2188 15.375 9.45052 15.2708 8.69531 15.0625C7.96615 14.8542 7.5625 14.75 7.48438 14.75C6.57292 14.75 5.77865 15.0885 5.10156 15.7656C4.45052 16.4167 4.125 17.1979 4.125 18.1094V19.125H17.875ZM14.9844 10.6094C13.8906 11.7031 12.5625 12.25 11 12.25C9.4375 12.25 8.10938 11.7031 7.01562 10.6094C5.92188 9.51562 5.375 8.1875 5.375 6.625C5.375 5.0625 5.92188 3.73438 7.01562 2.64062C8.10938 1.54688 9.4375 1 11 1C12.5625 1 13.8906 1.54688 14.9844 2.64062C16.0781 3.73438 16.625 5.0625 16.625 6.625C16.625 8.1875 16.0781 9.51562 14.9844 10.6094ZM13.6562 3.96875C12.9271 3.23958 12.0417 2.875 11 2.875C9.95833 2.875 9.07292 3.23958 8.34375 3.96875C7.61458 4.69792 7.25 5.58333 7.25 6.625C7.25 7.66667 7.61458 8.55208 8.34375 9.28125C9.07292 10.0104 9.95833 10.375 11 10.375C12.0417 10.375 12.9271 10.0104 13.6562 9.28125C14.3854 8.55208 14.75 7.66667 14.75 6.625C14.75 5.58333 14.3854 4.69792 13.6562 3.96875Z" fill="#000000"/></svg>';
				break;

			case 'search-solid':
				$icon = '<svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M20.7266 18.3047C20.9089 18.487 21 18.7083 21 18.9688C21 19.2292 20.9089 19.4505 20.7266 19.6328L19.6328 20.7266C19.4505 20.9089 19.2292 21 18.9688 21C18.7083 21 18.487 20.9089 18.3047 20.7266L14.3984 16.8203C14.2161 16.638 14.125 16.4167 14.125 16.1562V15.5312C12.6667 16.6771 11 17.25 9.125 17.25C6.88542 17.25 4.97135 16.4557 3.38281 14.8672C1.79427 13.2786 1 11.3646 1 9.125C1 6.88542 1.79427 4.97135 3.38281 3.38281C4.97135 1.79427 6.88542 1 9.125 1C11.3646 1 13.2786 1.79427 14.8672 3.38281C16.4557 4.97135 17.25 6.88542 17.25 9.125C17.25 11 16.6771 12.6667 15.5312 14.125H16.1562C16.4167 14.125 16.638 14.2161 16.8203 14.3984L20.7266 18.3047ZM5.57031 12.6797C6.5599 13.6432 7.74479 14.125 9.125 14.125C10.5052 14.125 11.6771 13.6432 12.6406 12.6797C13.6302 11.6901 14.125 10.5052 14.125 9.125C14.125 7.74479 13.6302 6.57292 12.6406 5.60938C11.6771 4.61979 10.5052 4.125 9.125 4.125C7.74479 4.125 6.5599 4.61979 5.57031 5.60938C4.60677 6.57292 4.125 7.74479 4.125 9.125C4.125 10.5052 4.60677 11.6901 5.57031 12.6797Z" fill="black"/></svg>';
				break;
			case 'shopping-bag-solid':
				$icon = '<svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M16 7.25H19.75V17.875C19.75 18.7344 19.4375 19.4635 18.8125 20.0625C18.2135 20.6875 17.4844 21 16.625 21H5.375C4.51562 21 3.77344 20.6875 3.14844 20.0625C2.54948 19.4635 2.25 18.7344 2.25 17.875V7.25H6V6C6 4.61979 6.48177 3.44792 7.44531 2.48438C8.4349 1.49479 9.61979 1 11 1C12.3802 1 13.5521 1.49479 14.5156 2.48438C15.5052 3.44792 16 4.61979 16 6V7.25ZM8.5 6V7.25H13.5V6C13.5 5.32292 13.2526 4.73698 12.7578 4.24219C12.263 3.7474 11.6771 3.5 11 3.5C10.3229 3.5 9.73698 3.7474 9.24219 4.24219C8.7474 4.73698 8.5 5.32292 8.5 6ZM14.0859 10.4141C14.2682 10.5964 14.4896 10.6875 14.75 10.6875C15.0104 10.6875 15.2318 10.5964 15.4141 10.4141C15.5964 10.2318 15.6875 10.0104 15.6875 9.75C15.6875 9.48958 15.5964 9.26823 15.4141 9.08594C15.2318 8.90365 15.0104 8.8125 14.75 8.8125C14.4896 8.8125 14.2682 8.90365 14.0859 9.08594C13.9036 9.26823 13.8125 9.48958 13.8125 9.75C13.8125 10.0104 13.9036 10.2318 14.0859 10.4141ZM6.58594 10.4141C6.76823 10.5964 6.98958 10.6875 7.25 10.6875C7.51042 10.6875 7.73177 10.5964 7.91406 10.4141C8.09635 10.2318 8.1875 10.0104 8.1875 9.75C8.1875 9.48958 8.09635 9.26823 7.91406 9.08594C7.73177 8.90365 7.51042 8.8125 7.25 8.8125C6.98958 8.8125 6.76823 8.90365 6.58594 9.08594C6.40365 9.26823 6.3125 9.48958 6.3125 9.75C6.3125 10.0104 6.40365 10.2318 6.58594 10.4141Z" fill="black"/></svg>';
				break;
			case 'star-solid':
				$icon = '<svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M9.86719 1.70312C10.1016 1.23438 10.4792 1 11 1C11.5208 1 11.8984 1.23438 12.1328 1.70312L14.6719 6.85938L20.375 7.71875C20.8958 7.77083 21.2344 8.04427 21.3906 8.53906C21.5469 9.03385 21.4427 9.46354 21.0781 9.82812L16.9375 13.8516L17.9141 19.5547C17.9922 20.0495 17.8229 20.4401 17.4062 20.7266C16.9896 21.0391 16.5599 21.0781 16.1172 20.8438L11 18.1875L5.88281 20.8438C5.4401 21.1042 5.01042 21.0781 4.59375 20.7656C4.17708 20.4531 4.00781 20.0495 4.08594 19.5547L5.0625 13.8516L0.921875 9.82812C0.557292 9.46354 0.453125 9.03385 0.609375 8.53906C0.765625 8.04427 1.10417 7.77083 1.625 7.71875L7.32812 6.85938L9.86719 1.70312Z" fill="black"/></svg>';
				break;
			case 'heart-solid':
				$icon = '<svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M19.0469 3.51094C18.3438 2.91198 17.5495 2.53438 16.6641 2.37813C15.7786 2.22188 14.9062 2.28698 14.0469 2.57344C13.1875 2.8599 12.4323 3.34167 11.7812 4.01875L11 4.8L10.2188 4.01875C9.56771 3.34167 8.8125 2.8599 7.95312 2.57344C7.09375 2.28698 6.22135 2.22188 5.33594 2.37813C4.45052 2.53438 3.65625 2.91198 2.95312 3.51094C2.14583 4.18802 1.58594 5.02135 1.27344 6.01094C0.960938 7.00052 0.908854 8.00313 1.11719 9.01875C1.35156 10.0083 1.83333 10.8807 2.5625 11.6359L10.1016 19.4094C10.362 19.6698 10.6615 19.8 11 19.8C11.3385 19.8 11.638 19.6698 11.8984 19.4094L19.4375 11.5969C20.1667 10.8677 20.6354 10.0083 20.8438 9.01875C21.0781 8.00313 21.0391 7.00052 20.7266 6.01094C20.4141 5.02135 19.8542 4.18802 19.0469 3.51094Z" fill="black"/></svg>';
				break;
			case 'user-solid':
				$icon = '<svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M14.5156 9.55469C13.5521 10.5182 12.3802 11 11 11C9.61979 11 8.4349 10.5182 7.44531 9.55469C6.48177 8.5651 6 7.38021 6 6C6 4.61979 6.48177 3.44792 7.44531 2.48438C8.4349 1.49479 9.61979 1 11 1C12.3802 1 13.5521 1.49479 14.5156 2.48438C15.5052 3.44792 16 4.61979 16 6C16 7.38021 15.5052 8.5651 14.5156 9.55469ZM14.5156 12.25C15.9479 12.25 17.1719 12.7708 18.1875 13.8125C19.2292 14.8281 19.75 16.0521 19.75 17.4844V19.125C19.75 19.6458 19.5677 20.0885 19.2031 20.4531C18.8385 20.8177 18.3958 21 17.875 21H4.125C3.60417 21 3.16146 20.8177 2.79688 20.4531C2.43229 20.0885 2.25 19.6458 2.25 19.125V17.4844C2.25 16.0521 2.75781 14.8281 3.77344 13.8125C4.8151 12.7708 6.05208 12.25 7.48438 12.25H8.14844C9.0599 12.6667 10.0104 12.875 11 12.875C11.9896 12.875 12.9401 12.6667 13.8516 12.25H14.5156Z" fill="black"/></svg>';
				break;

			case 'search-light':
				$icon = '<svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M20.8438 19.8281C21.0781 20.0365 21.0781 20.2578 20.8438 20.4922L20.4922 20.8438C20.2578 21.0781 20.0365 21.0781 19.8281 20.8438L14.7891 15.8438C14.6849 15.7396 14.6328 15.6224 14.6328 15.4922V15.1016C13.0703 16.5339 11.2344 17.25 9.125 17.25C6.88542 17.25 4.97135 16.4557 3.38281 14.8672C1.79427 13.2786 1 11.3646 1 9.125C1 6.88542 1.79427 4.97135 3.38281 3.38281C4.97135 1.79427 6.88542 1 9.125 1C11.3646 1 13.2786 1.79427 14.8672 3.38281C16.4557 4.97135 17.25 6.88542 17.25 9.125C17.25 11.2344 16.5339 13.0703 15.1016 14.6328H15.4922C15.6224 14.6328 15.7396 14.6849 15.8438 14.7891L20.8438 19.8281ZM4.24219 14.0078C5.59635 15.3359 7.22396 16 9.125 16C11.026 16 12.6406 15.3359 13.9688 14.0078C15.3229 12.6536 16 11.026 16 9.125C16 7.22396 15.3229 5.60938 13.9688 4.28125C12.6406 2.92708 11.026 2.25 9.125 2.25C7.22396 2.25 5.59635 2.92708 4.24219 4.28125C2.91406 5.60938 2.25 7.22396 2.25 9.125C2.25 11.026 2.91406 12.6536 4.24219 14.0078Z" fill="black"/></svg>';
				break;
			case 'shopping-bag-light':
				$icon = '<svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M15.95 6H19.7V17.875C19.7 18.7344 19.3875 19.4635 18.7625 20.0625C18.1635 20.6875 17.4344 21 16.575 21H5.325C4.46563 21 3.72344 20.6875 3.09844 20.0625C2.49948 19.4635 2.2 18.7344 2.2 17.875V6H5.95C5.95 4.61979 6.43177 3.44792 7.39531 2.48438C8.3849 1.49479 9.56979 1 10.95 1C12.3302 1 13.5021 1.49479 14.4656 2.48438C15.4552 3.44792 15.95 4.61979 15.95 6ZM13.6063 3.34375C12.8771 2.61458 11.9917 2.25 10.95 2.25C9.90833 2.25 9.02292 2.61458 8.29375 3.34375C7.56458 4.07292 7.2 4.95833 7.2 6H14.7C14.7 4.95833 14.3354 4.07292 13.6063 3.34375ZM18.45 17.875V7.25H15.95V9.125C15.95 9.30729 15.8849 9.46354 15.7547 9.59375C15.6505 9.69792 15.5073 9.75 15.325 9.75C15.1427 9.75 14.9865 9.69792 14.8563 9.59375C14.7521 9.46354 14.7 9.30729 14.7 9.125V7.25H7.2V9.125C7.2 9.30729 7.1349 9.46354 7.00469 9.59375C6.90052 9.69792 6.75729 9.75 6.575 9.75C6.39271 9.75 6.23646 9.69792 6.10625 9.59375C6.00208 9.46354 5.95 9.30729 5.95 9.125V7.25H3.45V17.875C3.45 18.3958 3.63229 18.8385 3.99688 19.2031C4.36146 19.5677 4.80417 19.75 5.325 19.75H16.575C17.0958 19.75 17.5385 19.5677 17.9031 19.2031C18.2677 18.8385 18.45 18.3958 18.45 17.875Z" fill="black"/></svg>';
				break;
			case 'star-light':
				$icon = '<svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M20.325 7.71875C20.8458 7.77083 21.1844 8.04427 21.3406 8.53906C21.4969 9.03385 21.3927 9.46354 21.0281 9.82812L16.8875 13.8516L17.8641 19.5547C17.9422 20.0495 17.7729 20.4401 17.3562 20.7266C16.9396 21.0391 16.5099 21.0781 16.0672 20.8438L10.95 18.1875L5.83281 20.8438C5.3901 21.1042 4.96042 21.0781 4.54375 20.7656C4.12708 20.4531 3.95781 20.0495 4.03594 19.5547L5.0125 13.8516L0.871875 9.82812C0.507292 9.46354 0.403125 9.03385 0.559375 8.53906C0.715625 8.04427 1.05417 7.77083 1.575 7.71875L7.27812 6.85938L9.81719 1.70312C10.0516 1.23438 10.4292 1 10.95 1C11.4708 1 11.8484 1.23438 12.0828 1.70312L14.6219 6.85938L20.325 7.71875ZM15.5594 13.4219L20.1687 8.92969L13.8016 8.03125L10.95 2.25L8.09844 8.03125L1.73125 8.92969L6.34062 13.4219L5.24687 19.75L10.95 16.7812L16.6531 19.75L15.5594 13.4219Z" fill="black"/></svg>';
				break;
			case 'heart-light':
				$icon = '<svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M19.0469 3.36094C18.3698 2.76198 17.5885 2.38438 16.7031 2.22813C15.8177 2.07188 14.9323 2.13698 14.0469 2.42344C13.1875 2.7099 12.4323 3.19167 11.7812 3.86875L11 4.68906L10.2188 3.86875C9.67188 3.29583 8.99479 2.85313 8.1875 2.54063C7.30208 2.20208 6.42969 2.0849 5.57031 2.18906C4.60677 2.29323 3.72135 2.68385 2.91406 3.36094C2.13281 4.03802 1.58594 4.87135 1.27344 5.86094C0.960938 6.85052 0.908854 7.85313 1.11719 8.86875C1.35156 9.85833 1.83333 10.7307 2.5625 11.4859L10.1016 19.2594C10.362 19.5198 10.6615 19.65 11 19.65C11.3385 19.65 11.638 19.5198 11.8984 19.2594L19.4375 11.4469C20.1667 10.7177 20.6354 9.85833 20.8438 8.86875C21.0781 7.85313 21.0391 6.85052 20.7266 5.86094C20.4141 4.87135 19.8542 4.03802 19.0469 3.36094ZM18.5391 10.5875L11 18.4L3.46094 10.5875C2.9401 10.0667 2.57552 9.42865 2.36719 8.67344C2.1849 7.89219 2.19792 7.13698 2.40625 6.40781C2.64062 5.57448 3.08333 4.88438 3.73438 4.3375C4.41146 3.76458 5.15365 3.45208 5.96094 3.4C6.61198 3.34792 7.27604 3.47813 7.95312 3.79063C8.5 4.05104 8.95573 4.37656 9.32031 4.76719L11 6.48594L12.6797 4.76719C13.0182 4.37656 13.474 4.06406 14.0469 3.82969C14.724 3.51719 15.388 3.37396 16.0391 3.4C16.8464 3.45208 17.5755 3.76458 18.2266 4.3375C18.9036 4.88438 19.3594 5.57448 19.5938 6.40781C19.8021 7.13698 19.8021 7.89219 19.5938 8.67344C19.4115 9.42865 19.0599 10.0667 18.5391 10.5875Z" fill="black"/></svg>';
				break;
			case 'user-light':
				$icon = '<svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M14.4656 12.25C15.8979 12.25 17.1219 12.7708 18.1375 13.8125C19.1792 14.8281 19.7 16.0521 19.7 17.4844V19.125C19.7 19.6458 19.5177 20.0885 19.1531 20.4531C18.7885 20.8177 18.3458 21 17.825 21H4.075C3.55417 21 3.11146 20.8177 2.74688 20.4531C2.38229 20.0885 2.2 19.6458 2.2 19.125V17.4844C2.2 16.0521 2.70781 14.8281 3.72344 13.8125C4.7651 12.7708 6.00208 12.25 7.43438 12.25C7.77292 12.25 8.26771 12.3542 8.91875 12.5625C9.59583 12.7708 10.2729 12.875 10.95 12.875C11.6271 12.875 12.3042 12.7708 12.9813 12.5625C13.6583 12.3542 14.1531 12.25 14.4656 12.25ZM18.45 19.125V17.4844C18.45 16.3906 18.0594 15.4531 17.2781 14.6719C16.4969 13.8906 15.5594 13.5 14.4656 13.5C14.3094 13.5 13.8667 13.6042 13.1375 13.8125C12.4344 14.0208 11.7052 14.125 10.95 14.125C10.1948 14.125 9.4526 14.0208 8.72344 13.8125C8.02031 13.6042 7.59063 13.5 7.43438 13.5C6.34063 13.5 5.40313 13.8906 4.62188 14.6719C3.84063 15.4531 3.45 16.3906 3.45 17.4844V19.125C3.45 19.3073 3.50208 19.4505 3.60625 19.5547C3.73646 19.6849 3.89271 19.75 4.075 19.75H17.825C18.0073 19.75 18.1505 19.6849 18.2547 19.5547C18.3849 19.4505 18.45 19.3073 18.45 19.125ZM14.4656 9.55469C13.5021 10.5182 12.3302 11 10.95 11C9.56979 11 8.3849 10.5182 7.39531 9.55469C6.43177 8.5651 5.95 7.38021 5.95 6C5.95 4.61979 6.43177 3.44792 7.39531 2.48438C8.3849 1.49479 9.56979 1 10.95 1C12.3302 1 13.5021 1.49479 14.4656 2.48438C15.4552 3.44792 15.95 4.61979 15.95 6C15.95 7.38021 15.4552 8.5651 14.4656 9.55469ZM13.6063 3.34375C12.8771 2.61458 11.9917 2.25 10.95 2.25C9.90833 2.25 9.02292 2.61458 8.29375 3.34375C7.56458 4.07292 7.2 4.95833 7.2 6C7.2 7.04167 7.56458 7.92708 8.29375 8.65625C9.02292 9.38542 9.90833 9.75 10.95 9.75C11.9917 9.75 12.8771 9.38542 13.6063 8.65625C14.3354 7.92708 14.7 7.04167 14.7 6C14.7 4.95833 14.3354 4.07292 13.6063 3.34375Z" fill="black"/></svg>';
				break;
			case 'cube':
				$icon = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path fill="#000000" d="M239.1 6.3l-208 78c-18.7 7-31.1 25-31.1 45v225.1c0 18.2 10.3 34.8 26.5 42.9l208 104c13.5 6.8 29.4 6.8 42.9 0l208-104c16.3-8.1 26.5-24.8 26.5-42.9V129.3c0-20-12.4-37.9-31.1-44.9l-208-78C262 2.2 250 2.2 239.1 6.3zM256 34.2l224 84v.3l-224 97.1-224-97.1v-.3l224-84zM32 153.4l208 90.1v224.7l-208-104V153.4zm240 314.8V243.5l208-90.1v210.9L272 468.2z"></path></svg>';
				break;
			case 'heart-2':
				$icon = '<svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M19.0859 3.46094C20.3099 4.5026 20.9609 5.83073 21.0391 7.44531C21.1172 9.0599 20.5964 10.4271 19.4766 11.5469L11.8984 19.3594C11.6641 19.6198 11.3776 19.75 11.0391 19.75C10.7005 19.75 10.401 19.6198 10.1406 19.3594L2.60156 11.5469C1.48177 10.4271 0.960938 9.0599 1.03906 7.44531C1.11719 5.83073 1.76823 4.5026 2.99219 3.46094C3.77344 2.78385 4.64583 2.39323 5.60938 2.28906C6.57292 2.1849 7.44531 2.30208 8.22656 2.64062C9.03385 2.95312 9.71094 3.39583 10.2578 3.96875L11.0391 4.78906L11.8203 3.96875C12.8099 2.95312 13.9948 2.39323 15.375 2.28906C16.7812 2.15885 18.0182 2.54948 19.0859 3.46094ZM18.5781 10.6875C19.3854 9.85417 19.7891 8.83854 19.7891 7.64062C19.7891 6.44271 19.2943 5.36198 18.3047 4.39844C17.6276 3.85156 16.8854 3.5651 16.0781 3.53906C15.2969 3.51302 14.6198 3.63021 14.0469 3.89062C13.5 4.15104 13.0573 4.47656 12.7188 4.86719L11.0391 6.58594L9.35938 4.86719C8.99479 4.47656 8.53906 4.15104 7.99219 3.89062C7.44531 3.60417 6.76823 3.48698 5.96094 3.53906C5.17969 3.5651 4.45052 3.85156 3.77344 4.39844C2.78385 5.36198 2.28906 6.45573 2.28906 7.67969C2.28906 8.8776 2.69271 9.88021 3.5 10.6875L11.0391 18.5L18.5781 10.6875Z" fill="black"/></svg>';
				break;
			case 'search-2':
				$icon = '<svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M20.8438 19.8281C21.0781 20.0365 21.0781 20.2578 20.8438 20.4922L20.4922 20.8438C20.2578 21.0781 20.0365 21.0781 19.8281 20.8438L14.7891 15.8438C14.6849 15.7396 14.6328 15.6224 14.6328 15.4922V15.1016C13.0703 16.5339 11.2344 17.25 9.125 17.25C6.88542 17.25 4.97135 16.4557 3.38281 14.8672C1.79427 13.2786 1 11.3646 1 9.125C1 6.88542 1.79427 4.97135 3.38281 3.38281C4.97135 1.79427 6.88542 1 9.125 1C11.3646 1 13.2786 1.79427 14.8672 3.38281C16.4557 4.97135 17.25 6.88542 17.25 9.125C17.25 11.2344 16.5339 13.0703 15.1016 14.6328H15.4922C15.6224 14.6328 15.7396 14.6849 15.8438 14.7891L20.8438 19.8281ZM4.24219 14.0078C5.59635 15.3359 7.22396 16 9.125 16C11.026 16 12.6406 15.3359 13.9688 14.0078C15.3229 12.6536 16 11.026 16 9.125C16 7.22396 15.3229 5.60938 13.9688 4.28125C12.6406 2.92708 11.026 2.25 9.125 2.25C7.22396 2.25 5.59635 2.92708 4.24219 4.28125C2.91406 5.60938 2.25 7.22396 2.25 9.125C2.25 11.026 2.91406 12.6536 4.24219 14.0078Z" fill="black"/></svg>';
				break;
			case 'shopping-bag-2':
				$icon = '<svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M18.9937 19.5541L18.4208 2.36795C18.4112 2.0792 18.1743 1.8501 17.8854 1.8501H4.11394C3.82501 1.8501 3.58815 2.0792 3.57851 2.36795L3.00469 19.5822C2.99987 19.7273 3.05412 19.8682 3.15505 19.9725C3.25601 20.0769 3.39498 20.1358 3.54012 20.1358H18.4592C18.4595 20.1358 18.4598 20.1358 18.4599 20.1358C18.7558 20.1358 18.9956 19.896 18.9956 19.6001C18.9956 19.5846 18.995 19.5692 18.9937 19.5541ZM4.09401 19.0644L4.63212 2.92153H17.3673L17.9053 19.0644H4.09401Z" fill="black"/><path d="M14.4424 5.59277C14.1466 5.59277 13.9067 5.83263 13.9067 6.12849C13.9067 7.73149 12.6026 9.03563 10.9996 9.03563C9.39657 9.03563 8.09242 7.73149 8.09242 6.12849C8.09242 5.83263 7.85257 5.59277 7.55671 5.59277C7.26085 5.59277 7.021 5.83263 7.021 6.12849C7.021 8.32227 8.80578 10.1071 10.9996 10.1071C13.1934 10.1071 14.9781 8.32227 14.9781 6.12849C14.9781 5.83263 14.7383 5.59277 14.4424 5.59277Z" fill="black"/></svg>';
				break;

			// Font Awesome.
			case 'far-video':
				$icon = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M543.9 96c-6.2 0-12.5 1.8-18.2 5.7L416 170.1v-58.3c0-26.4-23.2-47.8-51.8-47.8H51.8C23.2 64 0 85.4 0 111.8v288.4C0 426.6 23.2 448 51.8 448h312.4c28.6 0 51.8-21.4 51.8-47.8v-58.3l109.7 68.3c5.7 4 12.1 5.7 18.2 5.7 16.6 0 32.1-13 32.1-31.5V127.5C576 109 560.5 96 543.9 96zM368 200v198.9c-.6.4-1.8 1.1-3.8 1.1H51.8c-2 0-3.2-.6-3.8-1.1V113.1c.6-.4 1.8-1.1 3.8-1.1h312.4c2 0 3.2.6 3.8 1.1V200zm160 155.2l-112-69.8v-58.7l112-69.8v198.3z"/></svg>';
				break;
			case 'fal-box':
				$icon = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M509.5 184.6L458.9 32.8C452.4 13.2 434.1 0 413.4 0H98.6c-20.7 0-39 13.2-45.5 32.8L2.5 184.6c-1.6 4.9-2.5 10-2.5 15.2V464c0 26.5 21.5 48 48 48h416c26.5 0 48-21.5 48-48V199.8c0-5.2-.8-10.3-2.5-15.2zM32 199.8c0-1.7.3-3.4.8-5.1L83.4 42.9C85.6 36.4 91.7 32 98.6 32H240v168H32v-.2zM480 464c0 8.8-7.2 16-16 16H48c-8.8 0-16-7.2-16-16V232h448v232zm0-264H272V32h141.4c6.9 0 13 4.4 15.2 10.9l50.6 151.8c.5 1.6.8 3.3.8 5.1v.2z"/></svg>';
				break;
			case 'fal-shipping-fast':
				$icon = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><path d="M280 192c4.4 0 8-3.6 8-8v-16c0-4.4-3.6-8-8-8H40c-4.4 0-8 3.6-8 8v16c0 4.4 3.6 8 8 8h240zm352 192h-24V275.9c0-16.8-6.8-33.3-18.8-45.2l-83.9-83.9c-11.8-12-28.3-18.8-45.2-18.8H416V78.6c0-25.7-22.2-46.6-49.4-46.6H113.4C86.2 32 64 52.9 64 78.6V96H8c-4.4 0-8 3.6-8 8v16c0 4.4 3.6 8 8 8h240c4.4 0 8-3.6 8-8v-16c0-4.4-3.6-8-8-8H96V78.6c0-8.1 7.8-14.6 17.4-14.6h253.2c9.6 0 17.4 6.5 17.4 14.6V384H207.6C193 364.7 170 352 144 352c-18.1 0-34.6 6.2-48 16.4V288H64v144c0 44.2 35.8 80 80 80s80-35.8 80-80c0-5.5-.6-10.8-1.6-16h195.2c-1.1 5.2-1.6 10.5-1.6 16 0 44.2 35.8 80 80 80s80-35.8 80-80c0-5.5-.6-10.8-1.6-16H632c4.4 0 8-3.6 8-8v-16c0-4.4-3.6-8-8-8zm-488 96c-26.5 0-48-21.5-48-48s21.5-48 48-48 48 21.5 48 48-21.5 48-48 48zm272-320h44.1c8.4 0 16.7 3.4 22.6 9.4l83.9 83.9c.8.8 1.1 1.9 1.8 2.8H416V160zm80 320c-26.5 0-48-21.5-48-48s21.5-48 48-48 48 21.5 48 48-21.5 48-48 48zm80-96h-16.4C545 364.7 522 352 496 352s-49 12.7-63.6 32H416v-96h160v96zM256 248v-16c0-4.4-3.6-8-8-8H8c-4.4 0-8 3.6-8 8v16c0 4.4 3.6 8 8 8h240c4.4 0 8-3.6 8-8z"/></svg>';
				break;
			case 'fal-truck-moving':
				$icon = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><path d="M621.3 205.3l-58.5-58.5c-12-12-28.3-18.7-45.3-18.7H464V64c0-17.7-14.3-32-32-32H32C14.3 32 0 46.3 0 64v336c0 44.2 35.8 80 80 80 26.3 0 49.4-12.9 64-32.4 14.6 19.6 37.7 32.4 64 32.4 44.2 0 80-35.8 80-80 0-5.5-.6-10.8-1.6-16h163.2c-1.1 5.2-1.6 10.5-1.6 16 0 44.2 35.8 80 80 80s80-35.8 80-80c0-5.5-.6-10.8-1.6-16H624c8.8 0 16-7.2 16-16V250.5c0-17-6.7-33.2-18.7-45.2zM80 448c-26.5 0-48-21.5-48-48s21.5-48 48-48 48 21.5 48 48-21.5 48-48 48zm128 0c-26.5 0-48-21.5-48-48s21.5-48 48-48 48 21.5 48 48-21.5 48-48 48zm224-96H271.6c-14.6-19.3-37.5-32-63.6-32s-49 12.7-63.6 32h-.7C129 332.7 106 320 80 320c-18.1 0-34.6 6.2-48 16.4V64h400zm32-192h53.5c8.5 0 16.6 3.3 22.6 9.4l54.6 54.6H464zm64 288c-26.5 0-48-21.5-48-48s21.5-48 48-48 48 21.5 48 48-21.5 48-48 48zm80-96h-16.4c-14.6-19.3-37.5-32-63.6-32s-49 12.7-63.6 32h-.4v-96h144z"/></svg>';
				break;
			case 'fal-plus':
				$icon = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512"><path d="M376 232H216V72c0-4.42-3.58-8-8-8h-32c-4.42 0-8 3.58-8 8v160H8c-4.42 0-8 3.58-8 8v32c0 4.42 3.58 8 8 8h160v160c0 4.42 3.58 8 8 8h32c4.42 0 8-3.58 8-8V280h160c4.42 0 8-3.58 8-8v-32c0-4.42-3.58-8-8-8z"/></svg>';
				break;

			// Phosphor Regular.
			case 'phr-magnifying-glass':
				$icon = '<svg xmlns="http://www.w3.org/2000/svg" width="192" height="192" fill="#000000" viewBox="0 0 256 256"><rect width="256" height="256" fill="none"></rect><circle cx="116" cy="116" r="84" fill="none" stroke="#000000" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"></circle><line x1="175.4" y1="175.4" x2="224" y2="224" fill="none" stroke="#000000" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"></line></svg>';
				break;
			case 'phr-star':
				$icon = '<svg xmlns="http://www.w3.org/2000/svg" width="192" height="192" fill="#000000" viewBox="0 0 256 256"><rect width="256" height="256" fill="none"></rect><path d="M132.4,190.7l50.4,32c6.5,4.1,14.5-2,12.6-9.5l-14.6-57.4a8.7,8.7,0,0,1,2.9-8.8l45.2-37.7c5.9-4.9,2.9-14.8-4.8-15.3l-59-3.8a8.3,8.3,0,0,1-7.3-5.4l-22-55.4a8.3,8.3,0,0,0-15.6,0l-22,55.4a8.3,8.3,0,0,1-7.3,5.4L31.9,94c-7.7.5-10.7,10.4-4.8,15.3L72.3,147a8.7,8.7,0,0,1,2.9,8.8L61.7,209c-2.3,9,7.3,16.3,15,11.4l46.9-29.7A8.2,8.2,0,0,1,132.4,190.7Z" fill="none" stroke="#000000" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"></path></svg>';
				break;
			case 'phr-heart':
				$icon = '<svg xmlns="http://www.w3.org/2000/svg" width="192" height="192" fill="#000000" viewBox="0 0 256 256"><rect width="256" height="256" fill="none"></rect><path d="M128,216S28,160,28,92A52,52,0,0,1,128,72h0A52,52,0,0,1,228,92C228,160,128,216,128,216Z" fill="none" stroke="#000000" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"></path></svg>';
				break;
			case 'phr-user':
				$icon = '<svg xmlns="http://www.w3.org/2000/svg" width="192" height="192" fill="#000000" viewBox="0 0 256 256"><rect width="256" height="256" fill="none"></rect><circle cx="128" cy="96" r="64" fill="none" stroke="#000000" stroke-miterlimit="10" stroke-width="16"></circle><path d="M31,216a112,112,0,0,1,194,0" fill="none" stroke="#000000" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"></path></svg>';
				break;
			case 'phr-shopping-bag':
				$icon = '<svg xmlns="http://www.w3.org/2000/svg" width="192" height="192" fill="#000000" viewBox="0 0 256 256"><rect width="256" height="256" fill="none"></rect><rect x="32" y="48" width="192" height="160" rx="8" fill="none" stroke="#000000" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"></rect><path d="M168,88a40,40,0,0,1-80,0" fill="none" stroke="#000000" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"></path></svg>';
				break;
			case 'phr-shopping-cart-simple':
				$icon = '<svg xmlns="http://www.w3.org/2000/svg" width="192" height="192" fill="#000000" viewBox="0 0 256 256"><rect width="256" height="256" fill="none"></rect><circle cx="80" cy="216" r="16"></circle><circle cx="184" cy="216" r="16"></circle><path d="M42.3,72H221.7l-26.4,92.4A15.9,15.9,0,0,1,179.9,176H84.1a15.9,15.9,0,0,1-15.4-11.6L32.5,37.8A8,8,0,0,0,24.8,32H8" fill="none" stroke="#000000" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"></path></svg>';
				break;

			// Phosphor Bold.
			case 'phb-magnifying-glass':
				$icon = '<svg xmlns="http://www.w3.org/2000/svg" width="192" height="192" fill="#000000" viewBox="0 0 256 256"><rect width="256" height="256" fill="none"></rect><circle cx="116" cy="116" r="84" fill="none" stroke="#000000" stroke-linecap="round" stroke-linejoin="round" stroke-width="24"></circle><line x1="175.4" y1="175.4" x2="224" y2="224" fill="none" stroke="#000000" stroke-linecap="round" stroke-linejoin="round" stroke-width="24"></line></svg>';
				break;
			case 'phb-star':
				$icon = '<svg xmlns="http://www.w3.org/2000/svg" width="192" height="192" fill="#000000" viewBox="0 0 256 256"><rect width="256" height="256" fill="none"></rect><path d="M132.4,190.7l50.4,32c6.5,4.1,14.5-2,12.6-9.5l-14.6-57.4a8.7,8.7,0,0,1,2.9-8.8l45.2-37.7c5.9-4.9,2.9-14.8-4.8-15.3l-59-3.8a8.3,8.3,0,0,1-7.3-5.4l-22-55.4a8.3,8.3,0,0,0-15.6,0l-22,55.4a8.3,8.3,0,0,1-7.3,5.4L31.9,94c-7.7.5-10.7,10.4-4.8,15.3L72.3,147a8.7,8.7,0,0,1,2.9,8.8L61.7,209c-2.3,9,7.3,16.3,15,11.4l46.9-29.7A8.2,8.2,0,0,1,132.4,190.7Z" fill="none" stroke="#000000" stroke-linecap="round" stroke-linejoin="round" stroke-width="24"></path></svg>';
				break;
			case 'phb-heart':
				$icon = '<svg xmlns="http://www.w3.org/2000/svg" width="192" height="192" fill="#000000" viewBox="0 0 256 256"><rect width="256" height="256" fill="none"></rect><path d="M128,216S28,160,28,92A52,52,0,0,1,128,72h0A52,52,0,0,1,228,92C228,160,128,216,128,216Z" fill="none" stroke="#000000" stroke-linecap="round" stroke-linejoin="round" stroke-width="24"></path></svg>';
				break;
			case 'phb-user':
				$icon = '<svg xmlns="http://www.w3.org/2000/svg" width="192" height="192" fill="#000000" viewBox="0 0 256 256"><rect width="256" height="256" fill="none"></rect><circle cx="128" cy="96" r="64" fill="none" stroke="#000000" stroke-linecap="round" stroke-linejoin="round" stroke-width="24"></circle><path d="M31,216a112,112,0,0,1,194,0" fill="none" stroke="#000000" stroke-linecap="round" stroke-linejoin="round" stroke-width="24"></path></svg>';
				break;
			case 'phb-shopping-cart-simple':
				$icon = '<svg xmlns="http://www.w3.org/2000/svg" width="192" height="192" fill="#000000" viewBox="0 0 256 256"><rect width="256" height="256" fill="none"></rect><circle cx="80" cy="216" r="20"></circle><circle cx="184" cy="216" r="20"></circle><path d="M42.3,72H221.7l-24.1,84.4A16,16,0,0,1,182.2,168H81.8a16,16,0,0,1-15.4-11.6L32.5,37.8A8,8,0,0,0,24.8,32H12" fill="none" stroke="#000000" stroke-linecap="round" stroke-linejoin="round" stroke-width="24"></path></svg>';
				break;
		endswitch;

		return $icon;
	}
}

Minimog_SVG_Manager::instance()->initialize();
